#include "../../inc/tagId/QrfeTagId.h"

#include <QrfeGlobal>

QrfeTagId::QrfeTagId()
    : m_valid(false)
{
}

QrfeTagId::QrfeTagId(const QByteArray &epc)
    : m_epc(epc)
    , m_valid(true)
{
}

QrfeTagId::QrfeTagId(const QrfeTagId &other)
    : m_epc(other.m_epc)
    , m_valid(other.m_valid)
{
}

QString QrfeTagId::tagId() const
{
    return QrfeGlobal::bytesToString(m_epc);
}

bool QrfeTagId::isValid() const
{
    return m_valid;
}
